function xprime=doublepointmass_derivatives(t,x)

global max  centx centy p1 p2 p12 p21 root wx ax cx wy ay cy h  ar
global zx px kx zy py ky 
global uxsave uysave tsave

xp=x(1); %position
yp=x(2); 
vx=x(3); %velocity
vy=x(4);
pdx=x(5); %PD compensator
pdy=x(6);
eta=x(7); %high pass filter

J=max/(1+p1*(xp-centx)^2+p2*(yp-centy)^2)^(root);

ux=-ax*wx*wx*sin(wx*t)+pdx+(kx*cx*sin(wx*t)*(J-eta));
uy=ay*wy*wy*cos(wy*t)+pdy+(ky*cy*(-cos(wy*t))*(J-eta));

xprime(1)=vx;
xprime(2)=vy;
xprime(3)=ux+ar*rand;
xprime(4)=uy+ar*rand;
xprime(5)=px*pdx+(px-zx)*(kx*cx*sin(wx*t)*(J-eta));
xprime(6)=py*pdy+(py-zy)*(ky*cy*(-cos(wy*t))*(J-eta));
xprime(7)=h*(J-eta);

xprime=xprime.';
tsave = [tsave;t];
uxsave = [uxsave;vx];
uysave = [uysave;vy];